/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.pizzacraft.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import com.tiviacz.pizzacraft.blockentity.PizzaBlockEntity;
import com.tiviacz.pizzacraft.container.PizzaMenu;
import com.tiviacz.pizzacraft.util.FoodUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.MenuAccess;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ScreenPizza
extends AbstractContainerScreen<PizzaMenu>
implements MenuAccess<PizzaMenu> {
    public static final ResourceLocation SCREEN_PIZZA = new ResourceLocation("pizzacraft", "textures/gui/pizza.png");
    private final ScreenImage PIZZA_IMAGE = new ScreenImage(61, 9, 54, 54);
    private final ScreenImage PIZZA_PATTERN = new ScreenImage(61, 9, 54, 54);
    private final ScreenImage HUNGER_INFO = new ScreenImage(127, 30, 13, 13);
    private final PizzaBlockEntity blockEntity;

    public ScreenPizza(PizzaMenu menu, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)menu, inv, titleIn);
        this.blockEntity = menu.blockEntity;
        this.f_97735_ = 0;
        this.f_97736_ = 0;
        this.f_97726_ = 176;
        this.f_97727_ = 158;
        this.f_97731_ -= 6;
    }

    protected void m_7027_(PoseStack poseStack, int mouseX, int mouseY) {
        this.f_96547_.m_92889_(poseStack, this.blockEntity.m_5446_(), (float)this.f_97730_, (float)this.f_97731_, 0x404040);
    }

    public List<Component> getTooltip() {
        ArrayList<Component> components = new ArrayList<Component>();
        components.add((Component)Component.m_237110_((String)"information.pizzacraft.hunger", (Object[])new Object[]{FoodUtils.getHungerForSlice((int)((Integer)this.blockEntity.getRefillmentValues().getFirst()), false), (Integer)this.blockEntity.getRefillmentValues().getFirst() % 7 != 0 ? " (+" + (Integer)this.blockEntity.getRefillmentValues().getFirst() % 7 + ")" : "", this.blockEntity.getRefillmentValues().getFirst()}).m_130940_(ChatFormatting.BLUE));
        components.add((Component)Component.m_237110_((String)"information.pizzacraft.saturation", (Object[])new Object[]{Float.valueOf((float)((double)Math.round((double)(((Float)this.blockEntity.getRefillmentValues().getSecond()).floatValue() / 7.0f) * 100.0) / 100.0)), Float.valueOf((float)((double)Math.round((double)((Float)this.blockEntity.getRefillmentValues().getSecond()).floatValue() * 100.0) / 100.0))}).m_130940_(ChatFormatting.BLUE));
        if (!this.blockEntity.getEffects().isEmpty()) {
            components.add((Component)Component.m_237115_((String)"information.pizzacraft.effects").m_130940_(ChatFormatting.GOLD));
            for (Pair<MobEffectInstance, Float> pair : this.blockEntity.getEffects()) {
                components.add((Component)Component.m_237115_((String)((MobEffectInstance)pair.getFirst()).m_19576_()).m_130940_(((MobEffectInstance)pair.getFirst()).m_19544_().m_19483_().m_19497_()));
            }
        }
        return components;
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(poseStack);
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        this.m_7025_(poseStack, mouseX, mouseY);
        if (this.HUNGER_INFO.inButton(this, mouseX, mouseY)) {
            this.m_96597_(poseStack, this.getTooltip(), mouseX, mouseY);
        }
    }

    protected void m_7286_(PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)SCREEN_PIZZA);
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        this.m_93228_(poseStack, x, y, 0, 0, this.f_97726_, this.f_97727_);
        this.PIZZA_IMAGE.draw(poseStack, this, this.blockEntity.isRaw() ? 1 : 112, 159);
        this.PIZZA_PATTERN.draw(poseStack, this, this.blockEntity.isRaw() ? 56 : 167, 158);
        this.HUNGER_INFO.draw(poseStack, this, 127, 30);
    }

    public static class ScreenImage {
        private int X;
        private int Y;
        private int W;
        private int H;

        public ScreenImage(int U, int V, int W, int H) {
            this.X = U;
            this.Y = V;
            this.W = W;
            this.H = H;
        }

        public void draw(PoseStack poseStack, ScreenPizza screen, int U, int V) {
            screen.m_93228_(poseStack, screen.getGuiLeft() + this.X, screen.getGuiTop() + this.Y, U, V, this.W, this.H);
        }

        public boolean inButton(ScreenPizza screen, int mouseX, int mouseY) {
            return this.X <= (mouseX -= screen.getGuiLeft()) && mouseX <= this.X + this.W && this.Y <= (mouseY -= screen.getGuiTop()) && mouseY <= this.Y + this.H;
        }
    }
}

